/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.entity;

import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.hecco.bountifulfares.block.entity.BFBlockEntities;
import net.hecco.bountifulfares.block.entity.ImplementedInventory;
import net.hecco.bountifulfares.networking.BFMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CeramicDishBlockEntity
extends BlockEntity
implements ImplementedInventory {
    public static final int DEFAULT_COLOR = 0xFFFFFF;
    public int color = 0xFFFFFF;
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);

    public CeramicDishBlockEntity(BlockPos pos, BlockState state) {
        super(BFBlockEntities.CERAMIC_DISH_BLOCK_ENTITY, pos, state);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        if (this.color != 0xFFFFFF) {
            nbt.m_128405_("color", this.color);
            super.m_183515_(nbt);
        }
    }

    public void m_142466_(CompoundTag nbt) {
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        super.m_142466_(nbt);
        if (nbt.m_128451_("color") == 0) {
            this.color = 0xFFFFFF;
        } else {
            super.m_183515_(nbt);
            this.color = nbt.m_128451_("color");
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public boolean canInsertItem() {
        return this.m_8020_(0).m_41619_();
    }

    public void insertItem(ItemStack item) {
        assert (this.f_58857_ != null);
        if (!this.f_58857_.m_5776_()) {
            this.m_6836_(0, item.m_255036_(1));
            this.m_6596_();
        }
    }

    public void removeItem() {
        assert (this.f_58857_ != null);
        if (!this.f_58857_.m_5776_()) {
            this.m_6836_(0, Items.f_41852_.m_7968_());
            this.m_6596_();
        }
    }

    public static int getColor(BlockGetter world, BlockPos pos) {
        if (world == null) {
            return 0xFFFFFF;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CeramicDishBlockEntity) {
            CeramicDishBlockEntity ceramicDishBlockEntity = (CeramicDishBlockEntity)blockEntity;
            return ceramicDishBlockEntity.color;
        }
        return 0xFFFFFF;
    }

    @Override
    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction side) {
        return ((ItemStack)this.inventory.get(0)).m_41619_();
    }

    public void setInventory(NonNullList<ItemStack> list) {
        this.inventory.set(0, (Object)((ItemStack)list.get(0)));
    }

    public ItemStack getRenderStack() {
        return this.m_8020_(0);
    }

    @Override
    public void m_6596_() {
        if (!this.f_58857_.m_5776_()) {
            FriendlyByteBuf data = PacketByteBufs.create();
            data.writeInt(this.inventory.size());
            for (int i = 0; i < this.inventory.size(); ++i) {
                data.m_130055_((ItemStack)this.inventory.get(i));
            }
            data.m_130064_(this.m_58899_());
            for (ServerPlayer player : PlayerLookup.tracking((ServerLevel)((ServerLevel)this.f_58857_), (BlockPos)this.m_58899_())) {
                ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)BFMessages.CERAMIC_DISH_ITEM_SYNC, (FriendlyByteBuf)data);
            }
        }
        super.m_6596_();
    }
}

